/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int remaining = this.buffer.remaining();
        if (remaining == 0) {
            return -1;
        }
        if (remaining < len) {
            this.buffer.get(b, off, remaining);
            return remaining;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int remaining = this.buffer.remaining();
        if (n < (long)remaining) {
            this.buffer.position(this.buffer.position() + remaining);
            return remaining;
        }
        this.buffer.position((int)((long)this.buffer.position() + n));
        return n;
    }

    public int read() throws IOException {
        return this.buffer.get();
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public void mark(int readlimit) {
        this.buffer.mark();
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.buffer.reset();
    }
}

